/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.tsd;

import com.ibm.hwmca.base.tsd.TransmitSvcDataUtils;
import com.ibm.hwmca.base.tsd.TsdCopyDataException;
import com.ibm.hwmca.base.tsd.TsdEntryData;
import com.ibm.hwmca.base.tsd.TsdErrorIds;
import com.ibm.hwmca.base.tsd.TsdMediaInUseException;
import com.ibm.hwmca.base.tsd.TsdMediaLabelException;
import com.ibm.hwmca.base.tsd.TsdMediaNotReadyException;
import com.ibm.hwmca.base.tsd.TsdMediaWriteProtectedException;
import com.ibm.hwmca.base.tsd.TsdNoSpaceException;
import com.ibm.hwmca.base.tsd.TsdRetrieveDataException;
import com.ibm.hwmca.base.tsd.TsdSendData;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;

public class TsdWriteDisk
implements TsdErrorIds {
    private static final String TRACE_MASKT = "XTSDWRDT";
    private static final String TRACE_MASKF = "XTSDWRDF";
    private static final String TRACE_MASKD = "XTSDWRDD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "TsdWriteDisk");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private long mediaSpaceAvailable = 0L;
    private MediaServices mediaServices = null;
    private MediaDeviceIdentifier mediaDeviceIdentifier = null;
    private MediaDevice mediaDevice = null;
    private String mediaLabel = null;
    private File mediaMountPoint = null;
    private long totalSize = 0L;
    private boolean legacyRequest = true;

    public void executeDataCollectionProgram(String program, String parm, short msgNumber) throws HException {
        TsdWriteDisk.logError("TsdWriteDisk.executeDataCollectionProgram is called in error", null, (short)20596);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int targetMedia, TsdEntryData[] entryData) throws HException, TsdCopyDataException, TsdRetrieveDataException, TsdNoSpaceException, TsdMediaInUseException, TsdMediaNotReadyException, TsdMediaWriteProtectedException, TsdMediaLabelException {
        Object t;
        int ix;
        Trace.trace(TRACE_MASKT, "-> TsdWriteDisk.write()");
        if (targetMedia != 1 && targetMedia != 3) {
            HException h = new HException("invalid TSD targetMedia [" + targetMedia + "]");
            TsdWriteDisk.logError("TsdWriteDisk.write() invalid targetMedia [" + targetMedia + "]", h, (short)20596);
            throw h;
        }
        if (entryData == null) {
            HException h = new HException("Null TSD entryData");
            TsdWriteDisk.logError("TsdWriteDisk.write() null TSD entry data", h, (short)20596);
            throw h;
        }
        String stagingDirectory = null;
        String dataDirectory = null;
        try {
            dataDirectory = BaseFileControl.getFilePath("*.trm");
        }
        catch (HException e) {
            TsdWriteDisk.logError("TsdWriteDisk.write: error making staging directory", e, (short)20596);
            throw e;
        }
        stagingDirectory = dataDirectory + "tsd";
        Trace.trace(TRACE_MASKD, "staging Dir = " + stagingDirectory);
        this.prepareMedia(targetMedia);
        TransmitSvcDataUtils.startTsdFileProcessing();
        Object e = TransmitSvcDataUtils.tsdFileLock;
        synchronized (e) {
            if (TransmitSvcDataUtils.tempDirCounter.increment() > 1) {
                Trace.trace(TRACE_MASKF, "TSD: write disk: Number of open TSD requests for the Tsd temp dir," + stagingDirectory + " > 1. " + "Number open=" + TransmitSvcDataUtils.tempDirCounter.getValue());
            }
        }
        File dir = new File(stagingDirectory);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                this.mediaDevice.unlock();
                Object object = TransmitSvcDataUtils.tsdFileLock;
                synchronized (object) {
                    TransmitSvcDataUtils.tempDirCounter.decrement();
                }
                TransmitSvcDataUtils.endTsdFileProcessing();
                HException e2 = new HException("Tsd temp dir, " + stagingDirectory + " already exists, but is not a directory");
                TsdWriteDisk.logError("TsdSendData.send: TSD temp dir, " + stagingDirectory + "already exists, but is not a directory", e2, (short)20595);
                throw e2;
            }
            Trace.trace(TRACE_MASKF, "TSD: write disk: TSD temp dir, " + stagingDirectory + " already exists.");
        } else {
            dir.mkdir();
        }
        int numOfEntries = Array.getLength(entryData);
        Trace.trace(TRACE_MASKD, "num of entries = " + numOfEntries);
        try {
            for (ix = 0; ix < numOfEntries; ++ix) {
                TsdEntryData data = entryData[ix];
                this.getDataFromSource(data, stagingDirectory);
            }
        }
        catch (TsdRetrieveDataException e3) {
            this.mediaDevice.unlock();
            Object object = TransmitSvcDataUtils.tsdFileLock;
            synchronized (object) {
                if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                    TsdSendData.deleteAllFiles(stagingDirectory);
                    new File(stagingDirectory).delete();
                }
            }
            TransmitSvcDataUtils.endTsdFileProcessing();
            TsdWriteDisk.logError("TsdWriteDisk.write: error retrieving data for " + entryData[ix], e3, (short)20596);
            throw e3;
        }
        Trace.trace(TRACE_MASKF, "totalSize = " + this.totalSize + ", mediaSpace = " + this.mediaSpaceAvailable);
        if (this.totalSize == 0L) {
            this.mediaDevice.unlock();
            Object e3 = TransmitSvcDataUtils.tsdFileLock;
            synchronized (e3) {
                if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                    TsdSendData.deleteAllFiles(stagingDirectory);
                    new File(stagingDirectory).delete();
                }
            }
            TransmitSvcDataUtils.endTsdFileProcessing();
            t = new TsdRetrieveDataException("No Tsd files to write to diskette or dvd");
            TsdWriteDisk.logError("TsdWriteDisk.write: no files to write", (Throwable)t, (short)20596);
            throw t;
        }
        if (this.totalSize + 5000L > this.mediaSpaceAvailable) {
            this.mediaDevice.unlock();
            t = TransmitSvcDataUtils.tsdFileLock;
            synchronized (t) {
                if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                    TsdSendData.deleteAllFiles(stagingDirectory);
                    new File(stagingDirectory).delete();
                }
            }
            TransmitSvcDataUtils.endTsdFileProcessing();
            t = new TsdNoSpaceException("Not enough space for Tsd files: space available = " + this.mediaSpaceAvailable + ", needed " + this.totalSize);
            TsdWriteDisk.logInfo("TsdWriteDisk.write: not enough space on media for files", (Throwable)t, (short)20599);
            throw t;
        }
        int numberOfFiles = 0;
        File[] listOfFiles = new File(stagingDirectory).listFiles();
        if (listOfFiles == null || (numberOfFiles = Array.getLength(listOfFiles)) == 0) {
            this.mediaDevice.unlock();
            Object object = TransmitSvcDataUtils.tsdFileLock;
            synchronized (object) {
                if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                    new File(stagingDirectory).delete();
                }
            }
            TransmitSvcDataUtils.endTsdFileProcessing();
            TsdCopyDataException t2 = new TsdCopyDataException("No files in tsd staging directory");
            TsdWriteDisk.logError("TsdWriteDisk.write: no files in staging directory", t2, (short)20596);
            throw t2;
        }
        try {
            for (ix = 0; ix < numberOfFiles; ++ix) {
                String fileName = listOfFiles[ix].getName();
                String destName = this.mediaMountPoint + "/" + fileName;
                FileUtilities.copy(listOfFiles[ix], new File(destName));
            }
        }
        catch (Exception e4) {
            this.mediaDevice.unlock();
            Object destName = TransmitSvcDataUtils.tsdFileLock;
            synchronized (destName) {
                if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                    TsdSendData.deleteAllFiles(stagingDirectory);
                    new File(stagingDirectory).delete();
                }
            }
            TransmitSvcDataUtils.endTsdFileProcessing();
            TsdCopyDataException t3 = new TsdCopyDataException(e4);
            TsdWriteDisk.logInfo("TsdWriteDisk.write: Error copying file to media", t3, (short)20598);
            throw t3;
        }
        try {
            Trace.trace(TRACE_MASKD, "sleeping after copies before unlock ");
            Thread.sleep(3000L);
        }
        catch (Exception e5) {
            // empty catch block
        }
        Object object = TransmitSvcDataUtils.tsdFileLock;
        synchronized (object) {
            if (TransmitSvcDataUtils.tempDirCounter.decrement() < 1) {
                TsdSendData.deleteAllFiles(stagingDirectory);
                new File(stagingDirectory).delete();
            }
        }
        this.mediaDevice.unlock();
        TransmitSvcDataUtils.endTsdFileProcessing();
        Trace.trace(TRACE_MASKT, "<- TsdWriteDisk.write()");
    }

    /*
     * WARNING - void declaration
     */
    public void getDataFromSource(TsdEntryData entryData, String dir) throws TsdRetrieveDataException, HException {
        String fileName;
        Trace.trace(TRACE_MASKT, "-> TsdWriteDisk.getDataFromSource()");
        byte action = entryData.getDataType();
        String program = entryData.getProgramName();
        short messageNumber = entryData.getMessageNumber();
        String[] peFileInfo = new String[]{entryData.getFileName(), entryData.getPeFilePattern()};
        String listFileName = null;
        String startParm = "S";
        String endParm = "R";
        boolean wasExecuted = false;
        TransmitSvcDataUtils utilObject = entryData.getTsdUtilObject();
        if (messageNumber == 27 && utilObject != null) {
            utilObject.setPeData(peFileInfo);
            program = "peData";
        }
        Trace.trace(TRACE_MASKD, "action = " + action + ", program = " + program);
        if (utilObject == null) {
            Trace.trace(TRACE_MASKF, "TsdWriteDisk.getDataFromSource legacy request");
            this.legacyRequest = true;
        } else {
            this.legacyRequest = false;
        }
        if (action == 2 || action == 3 || action == 4 || action == 5) {
            try {
                if (this.legacyRequest) {
                    this.executeDataCollectionProgram(program, startParm, messageNumber);
                } else {
                    TsdSendData.executeTsdUtilMethod(utilObject, program, false);
                }
            }
            catch (HException h) {
                TsdWriteDisk.logError("TsdWriteDisk.getDataFromSource: error executing Tsd util program '" + program + "'", h, (short)20596);
            }
            wasExecuted = true;
        }
        if (action == 0 || action == 3 || action == 5) {
            fileName = null;
            try {
                fileName = entryData.getFileName();
                Trace.trace(TRACE_MASKD, "entryData fileName = [" + fileName + "]");
                this.totalSize = this.legacyRequest ? (this.totalSize += this.retrieveFile(fileName, dir)) : (this.totalSize += TsdSendData.retrieveFile(fileName, dir));
            }
            catch (TsdRetrieveDataException e) {
                if (this.legacyRequest && messageNumber == 27) {
                    HException h = new HException(e);
                    TsdWriteDisk.logInfo("TsdWriteDisk.getDataFromSource: can't retrieve single file [" + fileName + "]", h, (short)20596);
                    throw h;
                }
                TsdWriteDisk.logError("TsdWriteDisk.getDataFromSource: can't retrieve single file [" + fileName + "]", e, (short)20596);
                throw e;
            }
        }
        if (action == 1 || action == 2 || action == 4) {
            try {
                listFileName = entryData.getFileName();
                if (this.legacyRequest) {
                    this.retrieveFile(listFileName, dir);
                } else {
                    TsdSendData.retrieveFile(listFileName, dir);
                }
            }
            catch (TsdRetrieveDataException e) {
                TsdWriteDisk.logError("TsdWriteDisk.getDataFromSource: can't retrieve multi-file list file [" + listFileName + "]", e, (short)20596);
                throw e;
            }
            fileName = null;
            String nameOnly = null;
            int index = 0;
            Trace.trace(TRACE_MASKD, "listFileName = [" + listFileName + "]");
            index = listFileName.lastIndexOf("/");
            nameOnly = index > 0 ? listFileName.substring(index + 1) : ((index = listFileName.lastIndexOf("\\")) > 0 ? listFileName.substring(index + 1) : listFileName);
            String localName = dir + "/" + nameOnly;
            Trace.trace(TRACE_MASKD, "localName = [" + localName + "]");
            File listFile = new File(localName);
            try {
                BufferedReader in = new BufferedReader(new FileReader(listFile));
            }
            catch (FileNotFoundException e) {
                TsdRetrieveDataException t = new TsdRetrieveDataException(e);
                TsdWriteDisk.logError("TsdWriteDisk.getDataFromSource: multi-filelist file '" + localName + "' not found.", t, (short)20595);
                throw t;
            }
            do {
                try {
                    void var17_22;
                    fileName = var17_22.readLine();
                    Trace.trace(TRACE_MASKD, "input = [" + fileName + "]");
                    if (fileName == null || fileName.length() <= 1 || fileName.substring(0, 2).equals("/*")) continue;
                    this.totalSize += this.retrieveFile(fileName, dir);
                }
                catch (IOException e) {
                    TsdRetrieveDataException t = new TsdRetrieveDataException(e);
                    TsdWriteDisk.logError("TsdWriteDisk.getDataFromSource: unable to read multi-filelist file '" + localName + "'", t, (short)20596);
                    throw t;
                }
                catch (TsdRetrieveDataException e) {
                    TsdWriteDisk.logInfo("TsdWriteDisk.getDataFromSource: error retrieving one of multi-file [" + fileName + "]", e, (short)20599);
                }
            } while (fileName != null);
            listFile.delete();
        }
        if (wasExecuted) {
            try {
                Trace.trace(TRACE_MASKD, "executing program [" + program + "] for cleanup");
                if (utilObject == null) {
                    this.executeDataCollectionProgram(program, endParm, messageNumber);
                } else {
                    utilObject.setSatisfactoryCompletion(true);
                    TsdSendData.executeTsdUtilMethod(utilObject, program, true);
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "TsdWriteDisk: ignore exception from executing cleanup");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    public void prepareMedia(int targetMedia) throws HException, TsdMediaInUseException, TsdMediaWriteProtectedException, TsdMediaLabelException {
        Trace.trace(TRACE_MASKT, "-> TsdWriteDisk.prepareMedia()");
        try {
            LocalizableText tsdName = new LocalizableText("TSD");
            this.mediaServices = MediaServices.getMediaServices();
            if (this.mediaServices == null) {
                HException h = new HException("Tsd prepareMedia got null media services");
                TsdWriteDisk.logError("TsdWriteDisk.prepareMedia: null returned for media services", h, (short)20597);
                throw h;
            }
            Trace.trace(TRACE_MASKD, "mediaServices = [" + this.mediaServices + "]");
            Trace.trace(TRACE_MASKD, "targetMedia is " + targetMedia);
            this.mediaDeviceIdentifier = this.mediaServices.getPreferredDevice(targetMedia);
            if (this.mediaDeviceIdentifier == null) {
                HException h = new HException("Tsd prepareMedia got null media device identifier");
                TsdWriteDisk.logError("TsdWriteDisk.prepareMedia: no preferred device for mediatype", h, (short)20597);
                throw h;
            }
            this.mediaDevice = this.mediaServices.requestLock(tsdName, this.mediaDeviceIdentifier);
            if (!this.mediaDevice.isMounted()) {
                Trace.trace(TRACE_MASKD, "mounting media");
                this.mediaDevice.mountReadWrite();
            }
            if (this.mediaDevice.isReadOnly()) {
                Trace.trace(TRACE_MASKT, "<- TsdWriteDisk.prepareMedia() MediaDeviceException(readonly)");
                this.mediaDevice.unlock();
                TsdMediaWriteProtectedException t = new TsdMediaWriteProtectedException("Device is read only; needs to be writable");
                TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia: device is read only", t, (short)20598);
                throw t;
            }
            this.mediaLabel = this.mediaDevice.getLabel();
            if (!(this.mediaLabel == null || targetMedia == 1 || this.mediaLabel.equals("SRVDAT") || this.mediaLabel.equals("") || this.mediaLabel.equals("Volume"))) {
                TsdMediaLabelException t = new TsdMediaLabelException("wrong label [" + this.mediaLabel + "]");
                TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia: invalid media label", t, (short)20598);
                this.mediaDevice.unlock();
                throw t;
            }
            this.mediaSpaceAvailable = this.mediaDevice.getAvailableSpace();
            Trace.trace(TRACE_MASKF, "mediaSpace = " + this.mediaSpaceAvailable);
            this.mediaMountPoint = this.mediaDevice.getMountPoint();
        }
        catch (NoMediaPresentException e) {
            if (this.mediaDevice != null) {
                this.mediaDevice.unlock();
            }
            TsdMediaNotReadyException t = new TsdMediaNotReadyException(e);
            TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia() media not ready", t, (short)20598);
            throw t;
        }
        catch (MediaWriteProtectedException e) {
            if (this.mediaDevice != null) {
                this.mediaDevice.unlock();
            }
            TsdMediaWriteProtectedException t = new TsdMediaWriteProtectedException(e);
            TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia() media write protected", t, (short)20598);
            throw t;
        }
        catch (InvalidFileSystemException e) {
            if (this.mediaDevice != null) {
                this.mediaDevice.unlock();
            }
            TsdMediaLabelException t = new TsdMediaLabelException(e);
            TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia() invalid file system", t, (short)20598);
            throw t;
        }
        catch (MediaDeviceLockException e) {
            if (this.mediaDevice != null) {
                this.mediaDevice.unlock();
            }
            TsdMediaInUseException t = new TsdMediaInUseException(e);
            TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia() locked", t, (short)20598);
            throw t;
        }
        catch (MediaDeviceException e) {
            if (this.mediaDevice != null) {
                this.mediaDevice.unlock();
            }
            HException h = new HException(e);
            TsdWriteDisk.logInfo("TsdWriteDisk.prepareMedia() media device exception", h, (short)20597);
            throw h;
        }
        Trace.trace(TRACE_MASKT, "<- TsdWriteDisk.prepareMedia()");
    }

    public long retrieveFile(String fileName, String dir) throws TsdRetrieveDataException {
        String filePath;
        int index = fileName.lastIndexOf("/");
        if (index > 0) {
            Trace.trace(TRACE_MASKF, "filename= '" + fileName + "'");
            return TsdSendData.retrieveFile(fileName, dir);
        }
        try {
            filePath = BaseFileControl.getFilePath(fileName);
        }
        catch (HException e) {
            TsdRetrieveDataException t = new TsdRetrieveDataException("No file path for '" + fileName + "'");
            TsdWriteDisk.logError("TsdWriteDisk.retrieveFile: no file path for remote file", t, (short)20596);
            throw t;
        }
        Trace.trace(TRACE_MASKF, "path = '" + filePath + "' filename='" + fileName + "'");
        return TsdSendData.retrieveFile(filePath + fileName, dir);
    }

    private static void logError(String msg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(msg);
        errLog.log();
    }

    private static void logInfo(String msg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(msg);
        errLog.log(infoLog);
    }
}

